CREATE TABLE [dbo].[ADMISSION_REQ_H]
(
[PK] [int] NOT NULL IDENTITY(1, 1),
[ID] [int] NOT NULL,
[DOMAIN_ID] [NVARCHAR] (50) NOT NULL,
[IEN] [VARCHAR](50) NULL,
[PATIENT_UID] [UNIQUEIDENTIFIER] NOT NULL,
[ORDERED_DATE] [DATETIME] NOT NULL,
[IS_ACTIVE] [BIT] NOT NULL,
[SIGNED_BY_UID] [uniqueidentifier] NULL,
[SIGNED_DATE] [datetime] NULL,
[RELEASED_DATE] [datetime] NULL,
[PROVIDER_UID] [uniqueidentifier] NULL,
[VISTA_SITE_UID] [uniqueidentifier] NULL,
[HOSPITAL_LOCATION_UID] [uniqueidentifier] NULL,
[WARD_UID] [UNIQUEIDENTIFIER] NULL,
[ORDER_TEXT] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[TRANSACTION_TYPE_CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DATE] [datetime] NOT NULL,
[CREATED_BY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATION_UTC_DATE] [datetime] NOT NULL 
)
GO
-- Constraints and Indexes

ALTER TABLE [dbo].[ADMISSION_REQ_H] ADD CONSTRAINT [PK_ADMISSION_REQ_H] PRIMARY KEY CLUSTERED  ([PK])
GO
-- Extended Properties

EXEC sp_addextendedproperty N'MS_Description', N'Admission request table.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ_H', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'ID of the admission and reference key to the ACT table.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ_H', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ_H', 'COLUMN', N'CREATED_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ_H', 'COLUMN', N'DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Comments.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ_H', 'COLUMN', N'ORDER_TEXT'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Primary key.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ_H', 'COLUMN', N'PK'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Provider''s id - person.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ_H', 'COLUMN', N'PROVIDER_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Date and time for the release.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ_H', 'COLUMN', N'RELEASED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The medical person who signes the admission request document.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ_H', 'COLUMN', N'SIGNED_BY_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time of signing the admission request document.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ_H', 'COLUMN', N'SIGNED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Code of transaction(I = Inserted, U = Updated, D = Deleted).', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ_H', 'COLUMN', N'TRANSACTION_TYPE_CODE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The Id of the facility that was requested for the admission.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ_H', 'COLUMN', N'VISTA_SITE_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Order date.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADMISSION_REQ_H', @level2type=N'COLUMN',@level2name=N'ORDERED_DATE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'If order is active.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADMISSION_REQ_H', @level2type=N'COLUMN',@level2name=N'IS_ACTIVE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indentity column imported from VistA(VistA IEN)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADMISSION_REQ_H', @level2type=N'COLUMN',@level2name=N'IEN'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The Id of the ward from where the patient will be admitted.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADMISSION_REQ_H', @level2type=N'COLUMN',@level2name=N'WARD_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'UID of the patient.', 'SCHEMA', N'dbo', 'TABLE', N'ADMISSION_REQ_H', 'COLUMN', N'PATIENT_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The UTC date and time when the order was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ADMISSION_REQ_H', @level2type=N'COLUMN',@level2name=N'CREATION_UTC_DATE'
GO